#ifndef __CRepeatingButton__
#define __CRepeatingButton__

#include "CRolloverButton.hpp"
#include "../Basics/ITimedObject.hpp"

//	===========================================================================

using Exponent::GUI::Controls::CRolloverButton;
using Exponent::GUI::Basics::ITimedObject;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CRepeatingButton CRepeatingButton.hpp
			 * @brief A repeating button. If you keep the mouse down will keep firing event
			 *
			 * @date 17/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CRepeatingButton.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CRepeatingButton : public CRolloverButton, public ITimedObject
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 */
				CRepeatingButton(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CRepeatingButton();

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event);

				/**
				 * Handle the mouse movement
				 * @param event The event to handle
				 */
				virtual void handleMouseMovement(CMouseEvent &event);

//	===========================================================================

				/**
				 * Set the repeat time
				 * @param timeInMilliseconds Time in msec between repeat events
				 */
				virtual void setRepeatTime(const long timeInMilliseconds);

				/**
				 * On expired increment value and redraw
				 */
				virtual void timerExpired();

				/**
				 * Get the id
				 * @retval long The timer identifier 
				 */
				virtual long getTimerId() const { return this->getUniqueId(); }

//	===========================================================================

			protected:

//	===========================================================================

				long m_timeInMilliseconds;			/**< Repeat time */
				
			};
		}
	}
}
#endif	// End of CRepeatingButton.hpp